--
-- Fastnight
-- V1.1.0.0
--
-- @author apuehri
-- @date 23/11/2024
--
-- Copyright (c) apuehri
-- V1.0.0.0 ..... LS25 first implementation

fastnight = {};
fastnight.version = "1.0.0.0";
fastnight.debug = false;
fastnight.dir = g_currentModDirectory;
fastnight.settings = {};
fastnight.initUiDone = false;

function fastnight.prerequisitesPresent(specializations)
    return true;
end;

function fastnight:loadMap()
	print("--- loading FastNight V".. fastnight.version .. " (c) by aPuehri ---")
	if fastnight.debug then
		print("--- FastNight Debug ... fastnight:loadMap ++ isClient="..tostring(g_currentMission:getIsClient()).." ,isServer="..tostring(g_currentMission:getIsServer()).." ,isMasterUser="..tostring(g_currentMission.isMasterUser).." ,isMultiplayer="..tostring(g_currentMission.missionDynamicInfo.isMultiplayer).." ---");
	end;	

	-- Ui
	InGameMenu.onMenuOpened = Utils.appendedFunction(InGameMenu.onMenuOpened, fastnight.initUi);

	-- SaveSettings
	FSBaseMission.saveSavegame = Utils.appendedFunction(FSBaseMission.saveSavegame, fastnight.saveSettings);

	--initialize
	fastnight.manScaling = 0;
	fastnight.settings.autoDayTimeScale = true;
	fastnight.settings.startDayHour = 6;
	fastnight.settings.startDayMinute = 0;
	fastnight.settings.speedDay = 3;	
	fastnight.settings.autoNightTimeScale = true;
	fastnight.settings.startNightHour = 21;
	fastnight.settings.startNightMinute = 30;
	fastnight.settings.speedNight = 80;
	fastnight.settings.showHelp = true;
	
	--load Savegame
	fastnight:loadSettings();

	-- set fastnight.manScaling
	fastnight.manScaling = g_currentMission.missionInfo.timeScale;
end;

function fastnight:update(dt)
    -- register action event for player
	fastnight:registerActionEventsPlayer()

	-- Auto scaling Day / Night
	if fastnight.settings.autoDayTimeScale then
		if (math.abs(g_currentMission.environment.currentHour) == math.abs(fastnight.settings.startDayHour)) and (math.abs(g_currentMission.environment.currentMinute) == math.abs(fastnight.settings.startDayMinute)) then
			g_currentMission:setTimeScale(fastnight.settings.speedDay);
			fastnight.manScaling = fastnight.settings.speedDay;
		end;
	end;
	if fastnight.settings.autoNightTimeScale then	
		if (math.abs(g_currentMission.environment.currentHour) == math.abs(fastnight.settings.startNightHour)) and (math.abs(g_currentMission.environment.currentMinute) == math.abs(fastnight.settings.startNightMinute)) then
			g_currentMission:setTimeScale(fastnight.settings.speedNight);
			fastnight.manScaling = fastnight.settings.speedNight;
		end;
	end;
end;

function fastnight:registerActionEventsPlayer()
	-- FastNight Minus
	if fastnight.minusEventId == nil then
		local result, eventId = g_inputBinding:registerActionEvent('fastnight_Minus', fastnight, fastnight.actionFastnight_Minus, false , true , false , true);
		if result then
			fastnight.minusEventId = eventId;
			g_inputBinding:setActionEventTextPriority(eventId, GS_PRIO_LOW);
			g_inputBinding:setActionEventTextVisibility(eventId, fastnight.settings.showHelp);	
		end;
		if fastnight.debug then
			print("--- FastNight Debug ... fastnight:registerActionEventsPlayer FastNight Minus result = " .. tostring(result));
		end;
	end;
	
	-- FastNight Plus
	if fastnight.plusEventId == nil then
		local result, eventId = g_inputBinding:registerActionEvent('fastnight_Plus', fastnight, fastnight.actionFastnight_Plus, false , true , false , true);
		if result then
			fastnight.plusEventId = eventId;
			g_inputBinding:setActionEventTextPriority(eventId, GS_PRIO_LOW);
			g_inputBinding:setActionEventTextVisibility(eventId, fastnight.settings.showHelp);
		end;
		if fastnight.debug then
			print("--- FastNight Debug ... fastnight:registerActionEventsPlayer FastNight Plus result = " .. tostring(result));
		end;
	end;
end;

function fastnight:saveSettings()
	if fastnight.debug then
		print("--- FastNight Debug ... fastnight:saveSettings -- Settings will be saved");
	end;
	local modSettingsDir = getUserProfileAppPath() .. "modSettings";
	local fileName = "fastnight.xml";
	local createXmlFile = modSettingsDir .. "/" .. fileName;

	local xmlFile = createXMLFile("fastnight", createXmlFile, "fastnight");
	
	-- AutoDayTimeScale
	setXMLBool(xmlFile, "fastnight.daysetting#autoDayTimeScale",fastnight.settings.autoDayTimeScale);
	--startDayHour		
	setXMLInt(xmlFile, "fastnight.daysetting#startDayHour",fastnight.settings.startDayHour);
	--startDayMinute		
	setXMLInt(xmlFile, "fastnight.daysetting#startDayMinute",fastnight.settings.startDayMinute);
	--speedDay		
	setXMLInt(xmlFile, "fastnight.daysetting#speedDay",fastnight.settings.speedDay);
	-- AutoDayTimeScale
	setXMLBool(xmlFile, "fastnight.nightsetting#autoNightTimeScale",fastnight.settings.autoNightTimeScale);		
	--startNightHour		
	setXMLInt(xmlFile, "fastnight.nightsetting#startNightHour",fastnight.settings.startNightHour);
	--startNightMinute		
	setXMLInt(xmlFile, "fastnight.nightsetting#startNightMinute",fastnight.settings.startNightMinute);
	--speedNight		
	setXMLInt(xmlFile, "fastnight.nightsetting#speedNight",fastnight.settings.speedNight);
	-- ShowHelp
	setXMLBool(xmlFile, "fastnight.help#showHelp",fastnight.settings.showHelp);
	
	saveXMLFile(xmlFile);
	delete(xmlFile);
end;

function fastnight:loadSettings()
	if fastnight.debug then
		print("--- FastNight Debug ... fastnight:loadSettings --  Try to load settings");
	end;
	
	if g_currentMission:getIsServer() then
		local modSettingsDir = getUserProfileAppPath() .. "modSettings";
		local fileName = "fastnight.xml";
		local loadXmlFile = modSettingsDir .. "/" .. fileName;	
		
		if fileExists(loadXmlFile) then
			local xmlFile = loadXMLFile("fastnight", loadXmlFile)
			print("--- loading FastNight settings...");
			
			-- AutoDayTimeScale
			fastnight.settings.autoDayTimeScale = Utils.getNoNil(getXMLBool(xmlFile, "fastnight.daysetting#autoDayTimeScale"), true);
			--startDayHour
			local startDayHour = getXMLInt(xmlFile, "fastnight.daysetting#startDayHour");
			if startDayHour ~= nil then
				if startDayHour >= 0 and startDayHour <= fastnight.settings.startNightHour then
					fastnight.settings.startDayHour = startDayHour;
				end;
			end;			
			--startDayMinute
			local startDayMinute = getXMLInt(xmlFile, "fastnight.daysetting#startDayMinute");
			if startDayMinute ~= nil then
				if startDayMinute >= 0 and startDayMinute <= 59 then
					fastnight.settings.startDayMinute = startDayMinute;
				end;
			end;	
			--speedDay
			local speedDay = getXMLInt(xmlFile, "fastnight.daysetting#speedDay");
			if speedDay ~= nil then
				if speedDay >= 0 and speedDay <= 800 then
					fastnight.settings.speedDay = speedDay;
				end;
			end;
			-- AutoNightTimeScale
			fastnight.settings.autoNightTimeScale = Utils.getNoNil(getXMLBool(xmlFile, "fastnight.nightsetting#autoNightTimeScale"), true);			
			--startNightHour
			local startNightHour = getXMLInt(xmlFile, "fastnight.nightsetting#startNightHour");
			if startNightHour ~= nil then
				if startNightHour > startDayHour and startNightHour <= 24 then
					fastnight.settings.startNightHour = startNightHour;
				end;
			end;			
			--startNightMinute
			local startNightMinute = getXMLInt(xmlFile, "fastnight.nightsetting#startNightMinute");
			if startNightMinute ~= nil then
				if startNightMinute >= 0 and startNightMinute <= 59 then
					fastnight.settings.startNightMinute = startNightMinute;
				end;
			end;	
			--speedNight
			local speedNight = getXMLInt(xmlFile, "fastnight.nightsetting#speedNight");
			if speedNight ~= nil then
				if speedNight >= 0 and speedNight <= 800 then
					fastnight.settings.speedNight = speedNight;
				end;
			end;				
			-- ShowHelp
			fastnight.settings.showHelp = Utils.getNoNil(getXMLBool(xmlFile, "fastnight.help#showHelp"), true);
			
			delete(xmlFile);
		end;
	end;
end;

function fastnight:actionFastnight_Minus(actionName, keyStatus, arg3, arg4, arg5)
	if g_currentMission.isMasterUser then
		if (fastnight.manScaling >= 350) then
			fastnight.manScaling = fastnight.manScaling - 50;	
		elseif (fastnight.manScaling > 100) and (fastnight.manScaling <= 300) then
			fastnight.manScaling = fastnight.manScaling - 20;
		elseif (fastnight.manScaling > 40) and (fastnight.manScaling <= 100) then
			fastnight.manScaling = fastnight.manScaling - 10;
		elseif (fastnight.manScaling > 15) and (fastnight.manScaling <= 40) then
			fastnight.manScaling = fastnight.manScaling - 5;
		elseif (fastnight.manScaling > 1) and (fastnight.manScaling <= 15) then
			fastnight.manScaling = fastnight.manScaling - 1;
		elseif (fastnight.manScaling > 0) and (fastnight.manScaling <= 1) then
			fastnight.manScaling = fastnight.manScaling - 0.5;
		end;
		g_currentMission:setTimeScale(fastnight.manScaling);
	end;
end;

function fastnight:actionFastnight_Plus(actionName, keyStatus, arg3, arg4, arg5)
	if g_currentMission.isMasterUser then
		if (fastnight.manScaling < 1) then
			fastnight.manScaling = fastnight.manScaling + 0.5;	
		elseif (fastnight.manScaling >= 1) and (fastnight.manScaling < 15) then
			fastnight.manScaling = fastnight.manScaling + 1;
		elseif (fastnight.manScaling >= 15) and (fastnight.manScaling < 40) then
			fastnight.manScaling = fastnight.manScaling + 5;
		elseif (fastnight.manScaling >= 40) and (fastnight.manScaling < 100) then
			fastnight.manScaling = fastnight.manScaling + 10;
		elseif (fastnight.manScaling >= 100) and (fastnight.manScaling < 300) then
			fastnight.manScaling = fastnight.manScaling + 20;
		elseif (fastnight.manScaling >= 300) and (fastnight.manScaling < 800) then
			fastnight.manScaling = fastnight.manScaling + 50;			
		end;
		g_currentMission:setTimeScale(fastnight.manScaling);	
	end;
end;

function fastnight:initUi()
	if fastnight.debug then
		print("--- FastNight Debug ... fastnight:initUi");
	end;
	if not fastnight.initUiDone then
		local uiSettingsFastnight = fastnightUI.new(fastnight.settings,fastnight.debug);
		uiSettingsFastnight:registerSettings();
		fastnight.initUiDone = true;
	end;
end;

function fastnight:getSettingsFromUi()
	if fastnight.debug then
		DebugUtil.printTableRecursively(fastnight.settings,"--- fastnight:getSettingsFromUi - new settings: ",0,1);
	end;
	
	-- update showHelp
	if fastnight.minusEventId ~= nil then
		g_inputBinding:setActionEventTextVisibility(fastnight.minusEventId, fastnight.settings.showHelp);
	end;
	if fastnight.plusEventId ~= nil then
		g_inputBinding:setActionEventTextVisibility(fastnight.plusEventId, fastnight.settings.showHelp);
	end;

	-- send data from ui to server
	fastnightMultiplayerUpdEvent.sendEvent();
end;

addModEventListener(fastnight);

-- *****+++++*****+++++ Multiplayer *****+++++*****+++++
local origServerSendObjects = Server.sendObjects;

function Server:sendObjects(connection, x, y, z, viewDistanceCoeff)
	connection:sendEvent(fastnightMultiplayerJoinEvent:new());
	return origServerSendObjects(self, connection, x, y, z, viewDistanceCoeff);
end;

fastnightMultiplayerJoinEvent = {};
fastnightMultiplayerJoinEvent_mt = Class(fastnightMultiplayerJoinEvent, Event);
InitEventClass(fastnightMultiplayerJoinEvent, "fastnightMultiplayerJoinEvent");

function fastnightMultiplayerJoinEvent:emptyNew()
	local self = Event.new(fastnightMultiplayerJoinEvent_mt);
	self.className = 'fastnight.fastnightMultiplayerJoinEvent';
	return self;
end;

function fastnightMultiplayerJoinEvent:new()
	local self = fastnightMultiplayerJoinEvent.emptyNew()
	return self;
end;

-- Send data from the server to the client fastnightMultiplayerJoinEvent
function fastnightMultiplayerJoinEvent:writeStream(streamId, connection)
	if not connection:getIsServer() then	
		if fastnight.debug then
			print("--- FastNight Debug ... sending data to joining client: ..... ---");
		end;
		streamWriteUInt8(streamId, fastnight.settings.startDayHour);
		streamWriteUInt8(streamId, fastnight.settings.startDayMinute);
		streamWriteUInt8(streamId, fastnight.settings.speedDay);
		streamWriteBool(streamId, fastnight.settings.autoDayTimeScale);
		streamWriteUInt8(streamId, fastnight.settings.startNightHour);
		streamWriteUInt8(streamId, fastnight.settings.startNightMinute);
		streamWriteUInt8(streamId, fastnight.settings.speedNight);
		streamWriteBool(streamId, fastnight.settings.autoNightTimeScale);
		streamWriteBool(streamId, fastnight.settings.showHelp);
	end;	
end;

-- Read from the server fastnightMultiplayerJoinEvent
function fastnightMultiplayerJoinEvent:readStream(streamId, connection)
	if connection:getIsServer() then
		if fastnight.debug then
			print("--- FastNight Debug ... reading data from server: ..... ---");
		end;
		fastnight.settings.startDayHour = streamReadUInt8(streamId);
		fastnight.settings.startDayMinute = streamReadUInt8(streamId);
		fastnight.settings.speedDay = streamReadUInt8(streamId);
		fastnight.settings.autoDayTimeScale = streamReadBool(streamId);
		fastnight.settings.startNightHour = streamReadUInt8(streamId);
		fastnight.settings.startNightMinute = streamReadUInt8(streamId);
		fastnight.settings.speedNight = streamReadUInt8(streamId);
		fastnight.settings.autoNightTimeScale = streamReadBool(streamId);
		fastnight.settings.showHelp = streamReadBool(streamId);			
	end;
end;

fastnightMultiplayerUpdEvent = {};
fastnightMultiplayerUpdEvent_mt = Class(fastnightMultiplayerUpdEvent, Event);
InitEventClass(fastnightMultiplayerUpdEvent, "fastnightMultiplayerUpdEvent");

function fastnightMultiplayerUpdEvent:emptyNew()
	local self = Event.new(fastnightMultiplayerUpdEvent_mt);
	self.className = 'fastnight.fastnightMultiplayerUpdEvent';
	return self;
end;

function fastnightMultiplayerUpdEvent:new()
	local self = fastnightMultiplayerUpdEvent.emptyNew()
	return self;
end;

-- Send data from the client to the server fastnightMultiplayerUpdEvent
function fastnightMultiplayerUpdEvent:writeStream(streamId, connection)
	if connection:getIsServer() then	
		if fastnight.debug then
			print("--- FastNight Debug ... sending data to server: ..... ---");
		end;
		streamWriteUInt8(streamId, fastnight.settings.startDayHour);
		streamWriteUInt8(streamId, fastnight.settings.startDayMinute);
		streamWriteUInt8(streamId, fastnight.settings.speedDay);
		streamWriteBool(streamId, fastnight.settings.autoDayTimeScale);
		streamWriteUInt8(streamId, fastnight.settings.startNightHour);
		streamWriteUInt8(streamId, fastnight.settings.startNightMinute);
		streamWriteUInt8(streamId, fastnight.settings.speedNight);
		streamWriteBool(streamId, fastnight.settings.autoNightTimeScale);
		streamWriteBool(streamId, fastnight.settings.showHelp);
	end;	
end;

-- Read from the client fastnightMultiplayerUpdEvent
function fastnightMultiplayerUpdEvent:readStream(streamId, connection)
	if not connection:getIsServer() then
		if fastnight.debug then
			print("--- FastNight Debug ... reading data from client: ..... ---");
		end;
		fastnight.settings.startDayHour = streamReadUInt8(streamId);
		fastnight.settings.startDayMinute = streamReadUInt8(streamId);
		fastnight.settings.speedDay = streamReadUInt8(streamId);
		fastnight.settings.autoDayTimeScale = streamReadBool(streamId);
		fastnight.settings.startNightHour = streamReadUInt8(streamId);
		fastnight.settings.startNightMinute = streamReadUInt8(streamId);
		fastnight.settings.speedNight = streamReadUInt8(streamId);
		fastnight.settings.autoNightTimeScale = streamReadBool(streamId);
		fastnight.settings.showHelp = streamReadBool(streamId);
	end;
end;

function fastnightMultiplayerUpdEvent:sendEvent()
	if g_currentMission.missionDynamicInfo.isMultiplayer and not g_currentMission:getIsServer() then
        -- Send to server
        g_client:getServerConnection():sendEvent(fastnightMultiplayerUpdEvent:new());
	end;
end