--[[
Copyright (C) GtX (Andy), 2020

Author: GtX | Andy
Date: 12.10.2020
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]

local buildId = 1
local versionString = "0.0.0.0"

local modName = g_currentModName or ""
local modDirectory = g_currentModDirectory or ""

local validationFail

local function validateTypes(typeManager)
    if typeManager.typeName == "vehicle" then
        g_specializationManager:addSpecialization("rideableFirstPersonCamera", "RideableFirstPersonCamera", Utils.getFilename("scripts/specializations/RideableFirstPersonCamera.lua", modDirectory), nil)

        local specName = string.format("%s.rideableFirstPersonCamera", modName)
        local specialization = g_specializationManager:getSpecializationObjectByName(specName)

        if specialization ~= nil then
            for typeName, typeEntry in pairs(typeManager:getTypes()) do
                if specialization.prerequisitesPresent(typeEntry.specializations) then
                    typeManager:addSpecialization(typeName, specName)
                end
            end
        else
            Logging.warning("Failed to load specialization 'rideableFirstPersonCamera', mod '%s' may not perform as intended!", modName)
        end
    end
end

local function validateMod()
    local mod = g_modManager:getModByName(modName)

    if mod == nil or g_iconGenerator ~= nil then
        return true
    end

    versionString = mod.version or versionString

    if mod.modName == "FS25_HorseRidingCamera" or mod.modName == "FS25_HorseRidingCamera_update" then
        if mod.author ~= nil and #mod.author == 3 then
            return true
        end
    end

    validationFail = {
        startUpdateTime = 2000,

        update = function(self, dt)
            self.startUpdateTime = self.startUpdateTime - dt

            if self.startUpdateTime < 0 then
                local text = string.format(g_i18n:getText("horseRidingCamera_loadError", mod.modName), mod.modName, mod.author or "Unknown")

                if g_dedicatedServerInfo == nil then
                    if not g_gui:getIsGuiVisible() then
                        local dialog = g_gui:showDialog("YesNoDialog")

                        if dialog ~= nil then
                            dialog.target:setText(text)
                            dialog.target:setTitle(string.format("%s - Version %s", mod.title, versionString))
                            dialog.target:setDialogType(DialogElement.TYPE_LOADING)
                            dialog.target:setCallback(self.openModHubLink, nil, nil)
                            dialog.target:setButtonTexts(g_i18n:getText("button_modHubDownload"), g_i18n:getText("button_ok"))
                        end
                    end
                else
                    print("\n" .. text .. "\n    - https://farming-simulator.com/mods.php?&title=fs2025&filter=org&org_id=129652&page=0" .. "\n")
                    self.openModHubLink(false)
                end
            end
        end,

        openModHubLink = function(yes)
            if yes then
                openWebFile("mods.php?title=fs2025&filter=org&org_id=129652&page=0", "")
            end

            removeModEventListener(validationFail)
            validationFail = nil
        end
    }

    addModEventListener(validationFail)

    return false
end

local function init()
    if validateMod() then
        g_rideableFirstPersonCameraModName = modName
        TypeManager.validateTypes = Utils.prependedFunction(TypeManager.validateTypes, validateTypes)
    else
        Logging.devInfo("[%s] Failed to validate mod!", modName)
    end
end

init()
