--[[
Copyright (C) GtX (Andy), 2020

Author: GtX | Andy
Date: 12.10.2020
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


RideableFirstPersonCamera = {}

RideableFirstPersonCamera.MOD_NAME = g_rideableFirstPersonCameraModName or ""
RideableFirstPersonCamera.CAMERA_GLOBAL_XML = [[
<vehicle>
    <rideable>
        <firstPersonCamera node="0>%s|0" rotatable="true" limit="true" rotMinX="-0.7" rotMaxX="0.7" transMin="0" transMax="0" useMirror="false"
        useOutdoorSounds="true" isInside="true" isHeadTrackingEnabled="false" useWorldXZRotation="false" positionSmoothingParameter="0"/>
    </rideable>
</vehicle>
]]

function RideableFirstPersonCamera.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Rideable, specializations)
end

function RideableFirstPersonCamera.initSpecialization(specializations)
    local schema = Vehicle.xmlSchema

    schema:setXMLSpecializationType("RideableFirstPersonCamera")
    schema:register(XMLValueType.BOOL, "vehicle.rideable#globalFirstPersonCamera", "Block firstPerson camera from loading, mod rideables only", true)
    VehicleCamera.registerCameraXMLPaths(schema, "vehicle.rideable.firstPersonCamera")
    schema:setXMLSpecializationType()
end

function RideableFirstPersonCamera.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", RideableFirstPersonCamera)
    SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", RideableFirstPersonCamera)
    SpecializationUtil.registerEventListener(vehicleType, "onDelete", RideableFirstPersonCamera)
    SpecializationUtil.registerEventListener(vehicleType, "onCameraChanged", RideableFirstPersonCamera)
    SpecializationUtil.registerEventListener(vehicleType, "onVehicleCharacterChanged", RideableFirstPersonCamera)
end

function RideableFirstPersonCamera.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "getAllowCharacterVisibilityUpdate", RideableFirstPersonCamera.getAllowCharacterVisibilityUpdate)
end

function RideableFirstPersonCamera:onLoad(savegame)
    self.spec_rideableFirstPersonCamera = self[string.format("spec_%s.rideableFirstPersonCamera", RideableFirstPersonCamera.MOD_NAME)]

    local spec = self.spec_rideableFirstPersonCamera

    if spec ~= nil then
        spec.cameraIndex = 0
        spec.cameraAdded = false
        spec.cameraIsActive = false

        if self.xmlFile:getValue("vehicle.rideable#globalFirstPersonCamera", true) then
            local createCameraFromXML = function(xmlFile)
                local camera = VehicleCamera.new(self)

                if camera:loadFromXML(xmlFile, "vehicle.rideable.firstPersonCamera") then
                    camera.allowHeadTracking = false -- Block mod animals from using as it can clip on translation
                    camera.positionSmoothingParameter = 0 -- Make sure mods do not use or rider moves off saddle

                    return camera
                end

                camera:delete()

                return nil
            end

            if not self.xmlFile:hasProperty("vehicle.rideable.firstPersonCamera") then
                local firstPersonCamera = createCamera("firstPersonCamera", math.rad(60), 0.1, 5000)

                spec.cameraLinkNode = createTransformGroup("firstPersonLinkNode")

                link(self.components[1].node, spec.cameraLinkNode)
                link(spec.cameraLinkNode, firstPersonCamera)

                setRotation(firstPersonCamera, 0, math.rad(180), 0)
                setTranslation(firstPersonCamera, 0, 2.5, 0.06)

                local handle = loadXMLFileFromMemory("memoryXmlFile", string.format(RideableFirstPersonCamera.CAMERA_GLOBAL_XML, getChildIndex(spec.cameraLinkNode)))
                local xmlFile = XMLFile.new("rideableFirstPersonCamera", "", handle, Vehicle.xmlSchema)

                spec.camera = createCameraFromXML(xmlFile)

                if spec.camera == nil then
                    delete(spec.cameraLinkNode)
                    spec.cameraLinkNode = nil
                end

                xmlFile:delete()
            else
                spec.camera = createCameraFromXML(self.xmlFile)
            end
        end
    end
end

function RideableFirstPersonCamera:onPostLoad(savegame)
    local spec = self.spec_rideableFirstPersonCamera

    if spec ~= nil then
        if spec.camera ~= nil then
            local enterableSpec = self.spec_enterable

            if enterableSpec.vehicleCharacter ~= nil then
                table.insert(enterableSpec.cameras, spec.camera)
                enterableSpec.numCameras = #enterableSpec.cameras

                spec.cameraIndex = enterableSpec.numCameras
                spec.cameraAdded = true
            else
                spec.camera:delete()
            end
        end
    end
end

function RideableFirstPersonCamera:onDelete()
    local spec = self.spec_rideableFirstPersonCamera

    if spec ~= nil then
        spec.cameraAdded = false
    end
end

function RideableFirstPersonCamera:onCameraChanged(camera, camIndex)
    local spec = self.spec_rideableFirstPersonCamera

    if spec ~= nil and spec.cameraAdded then
        local vehicleCharacter = self:getVehicleCharacter()

        spec.cameraIsActive = camera == spec.camera

        if vehicleCharacter ~= nil then
            vehicleCharacter:setCharacterVisibility(not spec.cameraIsActive)
        end
    end
end

function RideableFirstPersonCamera:onVehicleCharacterChanged(vehicleCharacter)
    if vehicleCharacter ~= nil then
        vehicleCharacter:setCharacterVisibility(self:getAllowCharacterVisibilityUpdate())
    end
end

function RideableFirstPersonCamera:getAllowCharacterVisibilityUpdate(superFunc)
    if not superFunc(self) then
        return false
    end

    local spec = self.spec_rideableFirstPersonCamera

    if spec ~= nil and spec.cameraAdded and self:getIsEntered() then
        local activeCamera = self:getActiveCamera()

        if activeCamera ~= nil and activeCamera == spec.camera then
            return false
        end
    end

    return true
end
