SuperStrengthEvent = {}
SuperStrengthEvent_mt = Class(SuperStrengthEvent, Event)

InitEventClass(SuperStrengthEvent, "SuperStrengthEvent")

function SuperStrengthEvent.emptyNew()
	local self =  Event.new(SuperStrengthEvent_mt)
	return self
end

function SuperStrengthEvent.new(superStrengthActive, uniqueUserId)
	local self = SuperStrengthEvent.emptyNew()
	self.superStrengthActive = superStrengthActive or false
	self.uniqueUserId = uniqueUserId
	return self
end

function SuperStrengthEvent:readStream(streamId, connection)
	if not connection:getIsServer() then
		local superStrengthActive = streamReadBool(streamId)
		local uniqueUserId = streamReadString(streamId)

		local connectionPlayer = g_currentMission.playerSystem:getPlayerByConnection(connection)
		if connectionPlayer ~= nil then
			local targetPlayer = g_currentMission.playerSystem:getPlayerByUniqueId(uniqueUserId)
			for _, player in pairs(g_currentMission.playerSystem.players) do
				if targetPlayer.uniqueId == connectionPlayer.uniqueId then
					local currentlyActive = targetPlayer.hands.spec_hands.hasSuperStrength
					if superStrengthActive ~= currentlyActive then
						targetPlayer.hands:consoleCommandToggleSuperStrength()
						currentlyActive = targetPlayer.hands.spec_hands.hasSuperStrength
						g_server:broadcastEvent(SuperStrengthEvent.new(superStrengthActive, uniqueUserId))
					end
				end
			end
		end
	end
end

function SuperStrengthEvent:writeStream(streamId, connection)
	if connection:getIsServer() then
		streamWriteBool(streamId, self.superStrengthActive)
		streamWriteString(streamId, self.uniqueUserId)
	end
end
